/*
THIS SOFTWARE IS PROVIDED BY ANALOG DEVICES INC. ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR NON-INFRINGEMENT, ARE
DISCLAIMED. IN NO EVENT SHALL ANALOG DEVICES INC. BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.

YOU ASSUME ANY AND ALL RISK FROM THE USE OF THIS CODE OR SUPPORT FILE.

IT IS THE RESPONSIBILITY OF THE PERSON INTEGRATING THIS CODE INTO AN APPLICATION
TO ENSURE THAT THE RESULTING APPLICATION PERFORMS AS REQUIRED AND IS SAFE.

    Module       : startup.c
    Description  : Cortex-M3 startup file - ADuCRF101 Version
    Date         : 10 June 2010
    Version      : v1.00
    Changelog    : v1.00 Initial
*/
#include <cportabl.h>

//*****************************************************************************
//
// Forward declaration of the default fault handlers.
//
//*****************************************************************************
void RESET_EXCPT_HNDLR         (void) ATTRIBUTE_INTERRUPT;
void SysTick_Handler           (void) ATTRIBUTE_INTERRUPT;
void NmiSR                     (void) ATTRIBUTE_INTERRUPT;
void FaultISR                  (void) ATTRIBUTE_INTERRUPT;
void MemManage_Handler         (void) ATTRIBUTE_INTERRUPT;
void BusFault_Handler          (void) ATTRIBUTE_INTERRUPT;
void UsageFault_Handler        (void) ATTRIBUTE_INTERRUPT;
void SVC_Handler               (void) ATTRIBUTE_INTERRUPT;
void DebugMon_Handler          (void) ATTRIBUTE_INTERRUPT;
void PendSV_Handler            (void) ATTRIBUTE_INTERRUPT;

void WakeUp_Int_Handler        (void) ATTRIBUTE_INTERRUPT; // Wake Up Timer              [ 0]
void Ext_Int0_Handler          (void) ATTRIBUTE_INTERRUPT; // External Interrupt 0       [ 1]
void Ext_Int1_Handler          (void) ATTRIBUTE_INTERRUPT; // External Interrupt 1       [ 2]
void Ext_Int2_Handler          (void) ATTRIBUTE_INTERRUPT; // External Interrupt 2       [ 3]
void Ext_Int3_Handler          (void) ATTRIBUTE_INTERRUPT; // External Interrupt 3       [ 4]
void Ext_Int4_Handler          (void) ATTRIBUTE_INTERRUPT; // External Interrupt 4       [ 5]
void Ext_Int5_Handler          (void) ATTRIBUTE_INTERRUPT; // External Interrupt 5       [ 6]
void Ext_Int6_Handler          (void) ATTRIBUTE_INTERRUPT; // External Interrupt 6       [ 7]
void Ext_Int7_Handler          (void) ATTRIBUTE_INTERRUPT; // External Interrupt 7       [ 8]
void Ext_Int8_Handler          (void) ATTRIBUTE_INTERRUPT; // External Interrupt 8       [ 9]
void WDog_Tmr_Int_Handler      (void) ATTRIBUTE_INTERRUPT; // Watchdog timer handler     [10]
                                                           // Reserved                   [11]
void GP_Tmr0_Int_Handler       (void) ATTRIBUTE_INTERRUPT; // General purpose timer 0    [12]
void GP_Tmr1_Int_Handler       (void) ATTRIBUTE_INTERRUPT; // General purpose timer 1    [13]
void ADC0_Int_Handler          (void) ATTRIBUTE_INTERRUPT; // ADC Interrupt              [14]
void Flsh_Int_Handler          (void) ATTRIBUTE_INTERRUPT; // Flash IRQ                  [15]
void UART_Int_Handler          (void) ATTRIBUTE_INTERRUPT; // UART0                      [16]
void SPI0_Int_Handler          (void) ATTRIBUTE_INTERRUPT; // SPI 0                      [17]
void SPI1_Int_Handler          (void) ATTRIBUTE_INTERRUPT; // SPI 1                      [18]
void I2C0_Slave_Int_Handler    (void) ATTRIBUTE_INTERRUPT; // I2C0 Slave                 [19]
void I2C0_Master_Int_Handler   (void) ATTRIBUTE_INTERRUPT; // I2C0 Master                [20]
                                                           // Reserved                   [21]
void DMA_Err_Int_Handler       (void) ATTRIBUTE_INTERRUPT; // DMA Error interrupt        [22]
void DMA_SPI1_TX_Int_Handler   (void) ATTRIBUTE_INTERRUPT; // DMA SPI1 TX                [23]
void DMA_SPI1_RX_Int_Handler   (void) ATTRIBUTE_INTERRUPT; // DMA SPI1 RX                [24]
void DMA_UART_TX_Int_Handler   (void) ATTRIBUTE_INTERRUPT; // DMA UART TX                [25]
void DMA_UART_RX_Int_Handler   (void) ATTRIBUTE_INTERRUPT; // DMA UART RX                [26]
void DMA_I2C0_STX_Int_Handler  (void) ATTRIBUTE_INTERRUPT; // DMA I2C0 Slave TX          [27]
void DMA_I2C0_SRX_Int_Handler  (void) ATTRIBUTE_INTERRUPT; // DMA I2C0 Slave RX          [28]
void DMA_I2C0_MTX_Int_Handler  (void) ATTRIBUTE_INTERRUPT; // DMA I2C0 Master TX         [29]
void DMA_I2C0_MRX_Int_Handler  (void) ATTRIBUTE_INTERRUPT; // DMA I2C0 Master RX         [30]
                                                           // Reserved                   [31]
                                                           // Reserved                   [32]
                                                           // Reserved                   [33]
void DMA_ADC_Int_Handler       (void) ATTRIBUTE_INTERRUPT; // ADC                        [34]
void DMA_SPI0_TX_Int_Handler   (void) ATTRIBUTE_INTERRUPT; // DMA SPI0 TX                [35]
void DMA_SPI0_RX_Int_Handler   (void) ATTRIBUTE_INTERRUPT; // DMA SPI0 RX                [36]
void PWMTrip_Int_Handler       (void) ATTRIBUTE_INTERRUPT; // PWM Trip                   [37]
void PWM0_Int_Handler          (void) ATTRIBUTE_INTERRUPT; // PWM 0                      [38]
void PWM1_Int_Handler          (void) ATTRIBUTE_INTERRUPT; // PWM 1                      [39]
void PWM2_Int_Handler          (void) ATTRIBUTE_INTERRUPT; // PWM 2                      [40]
void PWM3_Int_Handler          (void) ATTRIBUTE_INTERRUPT; // PWM 3                      [41]

void UnUsed_Handler            (void) ATTRIBUTE_INTERRUPT;



//*****************************************************************************
//
//*****************************************************************************
//
// Reserve space for the stacks and heap
//
//*****************************************************************************
#ifndef MAIN_STACK_SIZE
#define MAIN_STACK_SIZE          0x00000100        // 1Kb Stack unless otherwise specified
#endif

#ifndef PROCESS_STACK_SIZE
#define PROCESS_STACK_SIZE       0x00000004
#endif

#ifndef HEAP_SIZE
#define HEAP_SIZE                0x00000020
#endif

// These variable need to be kept and placed in specific sections for correct
// placing by the linker.
SECTION_PLACE(KEEP_VAR(static unsigned long pulMainStack[MAIN_STACK_SIZE]), ".mainstackarea") ;
SECTION_PLACE(KEEP_VAR(static unsigned long pulProcessStack[PROCESS_STACK_SIZE]), ".processstackarea");
SECTION_PLACE(KEEP_VAR(static unsigned long pulHeap[HEAP_SIZE]), ".heaparea");
SECTION_PLACE(KEEP_VAR(const unsigned long UserProtAndSig[5]), ".sigprot") = {0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF};
SECTION_PLACE(KEEP_VAR(const unsigned long PageZeroCheckSum), ".PageZeroCheckSum") = 0x13107522;


         

//*****************************************************************************
//
// The minimal vector table for a Cortex M3.  Note that the proper constructs
// must be placed on this to ensure that it ends up at physical address
// 0x0000.0000.
//
//*****************************************************************************

typedef union
{
    void (*pfnHandler)(void);
    unsigned long * ulPtr;
}
uVectorEntry;

SECTION_PLACE(KEEP_VAR(const uVectorEntry __vector_table[]), VECTOR_SECTION) =
{
    // Designated initializers are C99 feature. The RealView compiler will need 
    // the "--c99" switch to enable this ".ulPtr". 
    // Keil uVision (RealView) - Place --c99 in "Options for Target"->"C/C++"->"Misc Controls"
    { .ulPtr = (unsigned long *)(pulMainStack + (sizeof(pulMainStack)/4) ) },  
    {RESET_EXCPT_HNDLR       } ,              // The reset handler
    {NmiSR                   } ,              // The NMI handler
    {FaultISR                } ,              // The hard fault handler
    {MemManage_Handler       } ,              // The MPU fault handler
    {BusFault_Handler        } ,              // The bus fault handler
    {UsageFault_Handler      } ,              // The usage fault handler
    {0                       } ,              // Reserved
    {0                       } ,              // Reserved
    {0                       } ,              // Reserved
    {0                       } ,              // Reserved
    {SVC_Handler             } ,              // SVCall handler
    {DebugMon_Handler        } ,              // Debug monitor handler
    {0                       } ,              // Reserved
    {PendSV_Handler          } ,              // The PendSV handler
    {SysTick_Handler         } ,              // The SysTick handler

    {WakeUp_Int_Handler      }  ,             // Wake Up Timer              [ 0]
    {Ext_Int0_Handler        }  ,             // External Interrupt 0       [ 1]
    {Ext_Int1_Handler        }  ,             // External Interrupt 1       [ 2]
    {Ext_Int2_Handler        }  ,             // External Interrupt 2       [ 3]
    {Ext_Int3_Handler        }  ,             // External Interrupt 3       [ 4]
    {Ext_Int4_Handler        }  ,             // External Interrupt 4       [ 5]
    {Ext_Int5_Handler        }  ,             // External Interrupt 5       [ 6]
    {Ext_Int6_Handler        }  ,             // External Interrupt 6       [ 7]
    {Ext_Int7_Handler        }  ,             // External Interrupt 7       [ 8]
    {Ext_Int8_Handler        }  ,             // External Interrupt 8       [ 9]
    {WDog_Tmr_Int_Handler    }  ,             // Watchdog timer handler     [10]
    {UnUsed_Handler          }  ,             // Reserved                   [11]
    {GP_Tmr0_Int_Handler     }  ,             // General purpose timer 0    [12]
    {GP_Tmr1_Int_Handler     }  ,             // General purpose timer 1    [13]
    {ADC0_Int_Handler        }  ,             // ADC Interrupt              [14]
    {Flsh_Int_Handler        }  ,             // Flash IRQ                  [15]
    {UART_Int_Handler        }  ,             // UART0                      [16]
    {SPI0_Int_Handler        }  ,             // SPI 0                      [17]
    {SPI1_Int_Handler        }  ,             // SPI 1                      [18]
    {I2C0_Slave_Int_Handler  }  ,             // I2C0 Slave                 [19]
    {I2C0_Master_Int_Handler }  ,             // I2C0 Master                [20]
    {UnUsed_Handler          }  ,             // Reserved                   [21]
    {DMA_Err_Int_Handler     }  ,             // DMA Error interrupt        [22]
    {DMA_SPI1_TX_Int_Handler }  ,             // DMA SPI1 TX                [23]
    {DMA_SPI1_RX_Int_Handler }  ,             // DMA SPI1 RX                [24]
    {DMA_UART_TX_Int_Handler }  ,             // DMA UART TX                [25]
    {DMA_UART_RX_Int_Handler }  ,             // DMA UART RX                [26]
    {DMA_I2C0_STX_Int_Handler}  ,             // DMA I2C0 Slave TX          [27]
    {DMA_I2C0_SRX_Int_Handler}  ,             // DMA I2C0 Slave RX          [28]
    {DMA_I2C0_MTX_Int_Handler}  ,             // DMA I2C0 Master TX         [29]
    {DMA_I2C0_MRX_Int_Handler}  ,             // DMA I2C0 Master RX         [30]
    {UnUsed_Handler          }  ,             // Reserved                   [31]
    {UnUsed_Handler          }  ,             // Reserved                   [32]
    {UnUsed_Handler          }  ,             // Reserved                   [33]
    {DMA_ADC_Int_Handler     }  ,             // ADC                        [34]
    {DMA_SPI0_TX_Int_Handler }  ,             // DMA SPI0 TX                [35]
    {DMA_SPI0_RX_Int_Handler }  ,             // DMA SPI0 RX                [36]
    {PWMTrip_Int_Handler     }  ,             // PWM Trip                   [37]
    {PWM0_Int_Handler        }  ,             // PWM 0                      [38]
    {PWM1_Int_Handler        }  ,             // PWM 1                      [39]
    {PWM2_Int_Handler        }  ,             // PWM 2                      [40]
    {PWM3_Int_Handler        }  ,             // PWM 3                      [41]
    {UnUsed_Handler          }                // Unused                     [42]
};

